


; remote controlled input selection and can be used with low noise stereo amplifier
; added immunity to interference

; CPU configuration
	ERRORLEVEL -302
	ERRORLEVEL -306

	list P=16F88
	#include p16f88.inc


;Program Configuration Register 1
		__CONFIG    _CONFIG1, _CP_OFF & _CCP1_RB0 & _DEBUG_OFF & _WRT_PROTECT_OFF & _CPD_OFF & _LVP_OFF & _BODEN_OFF & _MCLR_ON & _PWRTE_ON & _WDT_OFF & _INTRC_IO

;Program Configuration Register 2
		__CONFIG    _CONFIG2, _IESO_OFF & _FCMEN_OFF
; Define variables at memory locations

; EEPROM
EEPROM0		equ	H'00'	; stored remote selection (TV, SAT1, SAT2)
EEPROM1		equ	H'01'	; input selection (input1-6)

; RAM
; bank 0 

REMOTE_M		equ	H'20'	; remote control input ms byte
REMOTE_L		equ	H'21'	; remote control input LS byte
REM_FLG		equ	H'22'	; flag to indicate current remote control sequencing 
REM_CNT		equ	H'23'	; interrupt count for polling remote control signal
REM_COD		equ	H'24'	; remote control bit counter mode.
VALUE_1		equ	H'25'	; delay value
VALUE_2		equ	H'26'	; delay value
FLG_HL			equ	H'27'	; high or low remote control sign
STORE1			equ	H'28'	; remote storage ms byte
STORE2			equ	H'29'	; remote storage ls byte
CODE_SOURCE	equ	H'2A'	; code source (TV, SAT1, SAT2)
INPUT			equ	H'2B'	; input
TEMP			equ	H'2C'	; temporary
TEMP1			equ	H'2D'
TEMP2			equ	H'2E'	; temporary


; all banks ram
W_TMP			equ	H'70'	; temporary store for w in interrupt
STATUS_TMP	equ	H'71'	; temporary store of status in interrupt 


	ORG    H'2100'			; preprogram EEPROM locations
	DE		D'0'				; set at 00
	DE		B'00000001'		; input selection 1 	

; define reset and interrupt vector start addresses

	org		0				; start at address 0000h
	goto	MAIN			; normal service routines from Reset vector
	org     4					; interrupt vector 0004h, start interrupt routine here


; ************************************************************************************	
; start interrupt by saving w and status registers before altered by interrupt routine

INTERRUPT
; check interrupt source	

	btfss	INTCON,TMR0IF	; TMR0 overflow interrupt flag
	retfie 					; return when not timer 0 overflow
	movwf	W_TMP			; w to w_tmp storage
	swapf	STATUS,w		; status to w
	movwf	STATUS_TMP	; status in status_tmp  
	bcf		STATUS,RP0	; select memory bank 0
	bcf		STATUS,RP1

; adjust interrupt rate with counter

COUNTER
	movlw	D'207'			; freq is 4MHz/4/2/50. = 100us
	addwf	TMR0,f			; add to timer register and takes 2 cycles to start counting
	bcf		INTCON,TMR0IF	; clear TMRO interrupt flag

; check if RA6 has gone low for start of remote control sequence
	btfsc	REM_FLG,0		; has remote control sequence started		
	goto	REM_SEQ
	btfsc	PORTA,6		; 
	goto	RECLAIM
	bsf		REM_FLG,0		; set beginning of remote control flag
	
	movlw	D'22'			; initial time period to wait till next start bit
	movwf	REM_CNT
	movlw	D'13'			; shift register counter
	movwf	REM_COD
	bsf		REMOTE_L,0	; set first bit in remote control sequence
	clrf		FLG_HL			; clear bit 1 in high low flag
	bsf		REM_FLG,7		; start bit flag set	
	goto 	RECLAIM

REM_SEQ
	btfsc	REM_FLG,1		; has it finished
	goto	RECLAIM
	decfsz	REM_CNT,f		; decrease interrupt counter for timing
	goto	CKEDGE		; check if change in level
	bcf		REM_FLG,7		; clear start bit flag
	movlw	D'18'			; 18 x 100us = 1.8ms or period between valid bits
	movwf	REM_CNT
	rlf		REMOTE_L,f		; least sig byte in remote control code sequence
	rlf		REMOTE_M,f	; most sig byte 
	movf	PORTA,w		; check bit 6 portA
	andlw	B'01000000'		; mask out bits except bit 6
	movwf	FLG_HL			; place in flag
	btfsc	PORTA,6		; check if high or low
	goto	HI				; high so clear
	bsf		REMOTE_L,0	; if low set this bit
	goto	BY_HI			; bypass high
HI	
	bcf		REMOTE_L,0	; clear 0 bit
BY_HI		
	decfsz	REM_COD,f		; decrease shift register count
	goto	RECLAIM
	bsf		REM_FLG,1		; set end of remote control decoding flag
	goto	RECLAIM

; align change in level (edge detect) with REM_CNT counter
 
CKEDGE
	btfsc	REM_FLG,7		; start bit flag bypass edge detect as AGC level setting
	goto	RECLAIM
	movlw	B'01000000'		; select bit 6 for PORTA,6
	andwf	PORTA,w		; bit 6
	xorwf	FLG_HL,w		; compare PORTA,6 with FLAG (previous level)		
	btfsc	STATUS,Z		; Z=1 if zero then no change
	goto	RECLAIM		; no change 
	movlw	B'01000000'		; select bit 6 for PORTA,6
	andwf	PORTA,w		; bit 6 select 
	movwf	FLG_HL			; reload new level
	movlw	H'3'				; count of 3 for REM_CNT
	subwf	REM_CNT,w		; is REM_CNT larger or equal to 3
	btfss	STATUS,C
	goto	RECLAIM		; smaller than 3 
	movf	REM_CNT,w
	sublw	H'6'				; check if 6 or less
	btfss	STATUS,C
	goto	RECLAIM		; larger than 6 
	movlw	H'4'
	movwf	REM_CNT		; set REM_CNT to 4 to align with change in level
	
; end of interrupt reclaim w and status 

RECLAIM
	swapf	STATUS_TMP,w; status temp storage to w
	movwf	STATUS			; w to status register
	swapf	W_TMP,f		; swap upper and lower 4-bits in w_tmp
	swapf  	W_TMP,w		; swap bits and into w register
	retfie					; return from interrupt

;********************************************************************************************** 
  
; RESET		
; Set ports A & B

MAIN
	clrf		PORTA
	clrf		PORTB
	clrf		REM_CNT		; remote control polling counter
	clrf		REM_FLG		; remote control flag status
	clrf		CODE_SOURCE	; remote control encoding 0=TV, 1=SAT1, 2=SAT2
	clrf		STORE1			; remote storage
	clrf		STORE2

; set inputs/outputs
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'00000111'		; comparators off
	movwf	CMCON
	movlw	B'11100000'		; Inputs/outputs
	movwf	TRISB			; port B data direction register
	movlw	B'00000000'	; 
	movwf	OPTION_REG	; TMR0 prescaler is 2, PORTB pullups enabled
	movlw   B'11100011'		; Inputs/ outputs 
	movwf   TRISA			; port A data direction register
; analog inputs, A/D
	movlw	B'00000000'		; no analog inputs
	movwf	ANSEL
; oscillator
	movlw	B'01100000'		; for 4MHz
	movwf	OSCCON		; osc
	bcf		STATUS,RP0	; select memory bank 0

; Code selection is made with a switch closed at power up		
; check if S1, S2 or S3 closed on the front panel 
	movlw	B'00000000'
	movwf	PORTB			; set RB4 and RB3 low
	call		DELAY			; 1s
	call		DELAY			; 1s
	movf	PORTB,w
	andlw 	B'11100000'		; look at RB5 to RB7
	xorlw	B'11100000'		; if equal, then no switches are closed at power up
	btfsc	STATUS,Z	
	goto	READ_CODE_SELECT

; check which switch is low
; set RB3 high, RB4 is low to test for S1 and S3
; get initial code
	movlw	EEPROM0
	call		EEREAD		; sets EEADR
	movwf	CODE_SOURCE	; remote control source (TV, SAT1, SAT2)

	bsf		PORTB,3
	movlw	D'2'
	call		DELAYT			; 10ms
	bcf		PORTB,4
	movlw	D'2'
	call		DELAYT			; 10ms
; switches S1,S3
	movf	CODE_SOURCE,w
	btfss	PORTB,7		; S3. If low, set a 0 for TV	
	movlw	D'0'	
	btfss	PORTB,6		; S1. If low, set 1 for SAT1
	movlw	D'1'
	movwf	CODE_SOURCE

; set RB3 low, RB4 high to test for S2
	bcf		PORTB,3
	movlw	D'2'
	call		DELAYT			; 10ms
	bsf		PORTB,4
	movlw	D'2'
	call		DELAYT			; 10ms
; switch S2
	movf	CODE_SOURCE,w
	btfss	PORTB,6		; S2. If low, set 2 for SAT2
	movlw	D'2'
	movwf	CODE_SOURCE	; sets TV, SAT1 or SAT2
	
; light switch LED
	movf	CODE_SOURCE,w
	xorlw	D'0'
	btfsc	STATUS,Z
	bsf		PORTA,4		; switch 3 LED
	movf	CODE_SOURCE,w
	xorlw	D'1'
	btfsc	STATUS,Z
	bsf		PORTA,2		; switch 1 LED
	movf	CODE_SOURCE,w
	xorlw	D'2'
	btfsc	STATUS,Z
	bsf		PORTA,3		; switch 2 LED

; Store
	movlw	EEPROM0
	call		EEREAD		; sets EEADR
	movf	CODE_SOURCE,w
	call		EEWRITE

 ; Wait for switches to open
WAIT_OPEN
; set RB4 low
	bcf		PORTB,4
	movlw	D'2'
	call		DELAYT			; 10ms
WAIT_OPEN1
	movf	PORTB,w
	andlw 	B'11100000'		; look at RB5 to RB7
	xorlw	B'11100000'		; if equal, then switches are open
	btfsc	STATUS,Z	
	goto	READ_CODE_SELECT

	call		DELAY			; 1s
	goto	WAIT_OPEN1
	
READ_CODE_SELECT

	movlw	EEPROM0
	call		EEREAD		; sets EEADR
	movwf	CODE_SOURCE	; remote control source (TV, SAT1, SAT2)

READ_INPUT_SELECT

; S1 to S6 switch LEDs off
; PORTA3,2,4 all low
	clrf		PORTA
	
; read input selection (input1 to input6)
	movlw	EEPROM1
	call		EEREAD
	movwf	INPUT

; check RA0,1,7  all held low via connection to preamp
; if floating then set RA0,1&7 low and set RA6 high (IR input)

; initially, RA0,1,7 as high outputs
	bsf		STATUS,RP0	; select memory bank 1
	movlw   B'00100000'		; Inputs/ outputs 
	movwf   TRISA			; port A data direction register
	bcf		STATUS,RP0	; select memory bank 0
 	movlw	B'11000011'
	movwf	PORTA
; set as inputs
	bsf		STATUS,RP0	; select memory bank 1
	movlw   B'10100011'		; Inputs/ outputs 
	movwf   TRISA			; port A data direction register
	bcf		STATUS,RP0	; select memory bank 0
	nop
	nop
; check if RA0,1,7 are low
; if low then tied low via preamp connection
	btfsc	PORTA,7
	goto	SET_OUT			
	btfsc	PORTA,1
	goto	SET_OUT
	btfss	PORTA,0
	goto	SET_INPUT

SET_OUT; set as outputs

; RA0,1,7 as low outputs, RA6 input
	bsf		STATUS,RP0	; select memory bank 1
	movlw   B'01100000'		; Inputs/ outputs 
	movwf   TRISA			; port A data direction register
	bcf		STATUS,RP0	; select memory bank 0
 	clrf		PORTA

SET_INPUT
	movf	INPUT,w
	xorlw	D'1'
	btfsc	STATUS,Z
	bsf		PORTA,2		; input 1
	movf	INPUT,w
	xorlw	D'2'
	btfsc	STATUS,Z
	bsf		PORTA,3		; input 2
	movf	INPUT,w
	xorlw	D'3'
	btfsc	STATUS,Z
	bsf		PORTA,4		; input 3
	movf	INPUT,w
	xorlw	D'4'
	btfsc	STATUS,Z
	bsf		PORTB,0		; input 4
	movf	INPUT,w
	xorlw	D'5'
	btfsc	STATUS,Z
	bsf		PORTB,1		; input 5
	movf	INPUT,w
	xorlw	D'6'
	btfsc	STATUS,Z
	bsf		PORTB,2		; input 6

; interrupt enable 
INTERRUPT_ENABLE

	bsf		INTCON,TMR0IE	; set interrupt enable for TMR0 
	bsf		INTCON,GIE		; set global interrupt enable for above
	
; decode remote control signal, switch closures and RA0,1,7 input

CK_AGN
	
; check for pressed switch
	movlw	B'11100111'	; RB4 and RB3 low
	andwf	PORTB,f		; set RB3,4 low to check switches
; if any RB5,6,7 low then a switch is pressed
	btfss	PORTB,5
	goto	SWITCH
	btfss	PORTB,6
	goto	SWITCH
	btfss	PORTB,7
	goto	SWITCH
; check also for preamp data at RA1,RA0 and RA7
; if zero ignore
	movf	PORTA,w
	andlw	B'10000011'
	btfss	STATUS,Z
	goto	SW_CHANGED	; switch read

; check  for remote control entered flag
	
	btfsc	REM_FLG,1	; is remote control entered flag set
	goto	CODE_D
	
; remote control decoding
	
	btfsc	REM_FLG,1	; is remote control entered flag set
	goto	CODE_D	; check codes
	goto	CK_AGN

SWITCH
	clrf		REM_FLG		; clear any remote control flags

; read switches
; check which switch is low
; set RB3 high, RB4 is low to test for S1, S3 and S5
	bsf		PORTB,3
	movlw	D'2'
	call		DELAYT			; 10ms
	bcf		PORTB,4
	movlw	D'2'
	call		DELAYT			; 10ms
; switches S1,S3,S5
	clrw
	clrf		TEMP2			; start with 0
	btfss	PORTB,7		; S3. 	
	movlw	D'3'	
	btfss	PORTB,6		; S1 
	movlw	D'1'
	btfss	PORTB,5
	movlw	D'5'				; S5
	movwf	TEMP2
	movf	TEMP2,w		; if zero, no switch closed so check S2,4,6.
	btfsc	STATUS,Z
	goto	OTHER_SW
	movwf	INPUT
	goto	WRI_SW		; valid switch so store
	
OTHER_SW
; set RB3 low, RB4 high to test for S2,S4 and S6
	bcf		PORTB,3
	movlw	D'2'
	call		DELAYT			; 10ms
	bsf		PORTB,4
	movlw	D'2'
	call		DELAYT			; 10ms
; switch S2,S4,S6
	clrw
	clrf		TEMP2			; start with 0
	btfss	PORTB,6		; S2 
	movlw	D'2'
	btfss	PORTB,7
	movlw	D'4'				; S4
	btfss	PORTB,5
	movlw	D'6'				; S6
	movwf	TEMP2
	movf	TEMP2,w		; if zero, no switch closed so check S2,4,6.
	btfsc	STATUS,Z
	goto	SET_SELECT	; bypass store
	movwf	INPUT

; write to EEPROM
WRI_SW
	bcf		INTCON,GIE		; disable interrupt
	movlw	EEPROM1
	call		EEREAD		; sets EEADR
	movf	INPUT,w
	call		EEWRITE
	
; set output for selected input
SET_SELECT
; set outputs for  selected input
; initial settings
	movlw	B'01000000'		; keep RA6 high if it is an output (IR receiver input)
	movwf	PORTA
	clrf		PORTB

	movf	INPUT,w
	xorlw	D'1'
	btfsc	STATUS,Z
	bsf		PORTA,2		; input 1
	movf	INPUT,w
	xorlw	D'2'
	btfsc	STATUS,Z
	bsf		PORTA,3		; input 2
	movf	INPUT,w
	xorlw	D'3'
	btfsc	STATUS,Z
	bsf		PORTA,4		; input 3
	movf	INPUT,w
	xorlw	D'4'
	btfsc	STATUS,Z
	bsf		PORTB,0		; input 4
	movf	INPUT,w
	xorlw	D'5'
	btfsc	STATUS,Z
	bsf		PORTB,1		; input 5
	movf	INPUT,w
	xorlw	D'6'
	btfsc	STATUS,Z
	bsf		PORTB,2		; input 6

 ; Wait for switches to open

; set RB4 low
	bcf		PORTB,4
	movlw	D'2'
	call		DELAYT			; 10ms
; RB3 low
	bcf		PORTB,3
	movlw	D'2'
	call		DELAYT			; 10ms
WAIT_OPEN2
	movf	PORTB,w
	andlw 	B'11100000'	; look at RB5 to RB7
	xorlw	B'11100000'	; if equal, then switches are open
	btfsc	STATUS,Z	
	goto	INPUT_CYC

	movlw	D'25'
	call		DELAYT			; 100ms
	goto	WAIT_OPEN2

INPUT_CYC
	movlw	D'25'
	call		DELAYT			; 0.1s
	goto	CK_AGN

SW_CHANGED	; use values found for input value at RA0,1,7 via IR remote from preamp
	movf	PORTA,w
	andlw	B'10000011'		; look at RA7,RA1,RA0
	movwf	TEMP2
	movlw	D'25'
	call		DELAYT			; 0.1s
	movf	PORTA,w
	andlw	B'10000011'		; look again
	xorwf	TEMP2,w
	btfss	STATUS,Z		; if both readings of PORTA the same continue on
	goto	SW_CHANGED	; check again

	clrf		TEMP1
	btfsc	TEMP2,7
	bsf		TEMP1,2		; set when bit 7 is set
	btfsc	TEMP2,1
	bsf		TEMP1,0
	btfsc	TEMP2,0
	bsf		TEMP1,1

; transfer new values
	movf	TEMP1,w
	movwf	INPUT

; set outputs for  selected input
; initial settings
	movlw	B'01000000'		; keep RA6 high if it is an output (IR receiver input)
	movwf	PORTA
	clrf		PORTB

	movf	INPUT,w
	xorlw	D'1'
	btfsc	STATUS,Z
	bsf		PORTA,2		; input 1
	movf	INPUT,w
	xorlw	D'2'
	btfsc	STATUS,Z
	bsf		PORTA,3		; input 2
	movf	INPUT,w
	xorlw	D'3'
	btfsc	STATUS,Z
	bsf		PORTA,4		; input 3
	movf	INPUT,w
	xorlw	D'4'
	btfsc	STATUS,Z
	bsf		PORTB,0		; input 4
	movf	INPUT,w
	xorlw	D'5'
	btfsc	STATUS,Z
	bsf		PORTB,1		; input 5
	movf	INPUT,w
	xorlw	D'6'
	btfsc	STATUS,Z
	bsf		PORTB,2		; input 6

; wait for RA0,1,7 to be 0
; if zero ignore
WAITX
	movf	PORTA,w
	andlw	B'10000011'
	btfss	STATUS,Z
	goto	WAITX		; wait till all 0
	goto	WRI_SW	; write to EEPROM

; Philips RC5 code for infra red transmission (also used with Marantz, Grundig and Loewe)
; Comprises 2 start bits, 1 toggle bit (alternates high or low on successive same key press)
; 5-system address bits and 6 command bits. Data stream starts with the start bits. 
; biphase encoding with high to a low transition = a low and low to high = high
; each bit transmitted at 1.778ms rate. Whole code at 24.889ms and next code starts 113.778ms
; later. Can decode by detecting first start bit then waiting 1.778ms + 444.5us for next start
; bit. Successive bits are 1.778ms apart. Total of 14 bits. 

;Address
;0 TV1
;1 TV2
;2 Videotext
;3 Expansion for TV1 and TV2
;4 Laser vision player
;5 VCR1
;6 VCR2
;7 Reserved
;8 SAT1
;9 Expansion for VCR1 and VCR2
;10 SAT2
;11 Reserved
;12 CD Video
;13 Reserved
;14 CD Photo
;15 Reserved
;16 Audio preamplifier1
;17 Tuner
;18 Analogue cassetter recorder
;19 Audio Preamp2
;20 CD
;21 Audio rack
;22 Audio Satellite
;23 DCC Recorder
;24 Reserved
;25 Reserved
;26 Writable CD
;27-31 Reserved

;Keycode commands 
;0 0
;1 1
;2 2
;3 3
;4 4
;5 5
;6 6
;7 7
;8 8
;9 9
;16 Volume +
;17 Volume -
;18 Brightness +
;19 Brightness -
;20 Colour saturation +
;21 Colour Saturation -
;22 Bass +
;23 Bass -
;24 Treble +
;25 Treble -
;26 Balance right
;27 balance left
;63 System select
;71 Dim local display

; Special commands
;10 1/2/3 digits /10
;11 Freq/prog/ch11
;12 standby
;13 Mute
;14 Personal preference
;15 Display
;28 Contrast +
;29 Contrast -
;30 Search +
;31 Tint/hue
;32 CH/prog +
;33 CH/prog -
;34 Alternate CH

;37 stereo/mono
;39 Tint/hue +
;48 Pause
;50 rewind
;52 wind
;53 play
;54 stop
;55 record

; compare with address code out if invalid clear REM_FLG
; if valid check command bits and ls 2 address bits then clear REM_FLG
; but first check which code is selected 
	
CODE_D

; compare remote code with last received. Requires 2 matching consecutive codes before an an action occurs
;	movf	REMOTE_M,w	; most significant remote code 
;	andlw	B'00110111'	; mask out bit 7 and 6 and toggle bit
;	movwf	TEMP
;	movf	STORE1,w
;	andlw	B'00110111' ; mask bit 6 and 7
;	xorwf	TEMP,w
;	btfsc	STATUS,Z
;	goto	NEXT_BYTE	; the same codes so check next code byte

TRANSFER ; transfer values when not the same
	
;	movf	REMOTE_M,w	; transfer codes
;	movwf	STORE1	
;	movf	REMOTE_L,w
;	movwf	STORE2
;	goto	CLR_RMF

; compare next byte	
NEXT_BYTE
; compare remote code with last received. Requires 2 matching consecutive codes before an an action occurs
;	movf	REMOTE_L,w	; most significant remote code 
;	xorwf	STORE2,w
;	btfss	STATUS,Z
;	goto	TRANSFER	; not the same values

; matching consecutive codes
; check code source
	movf	CODE_SOURCE,w ; TV, SAT1, SAT2
	btfsc	STATUS,Z
	goto	TV_1
	xorlw	D'1'
	btfsc	STATUS,Z
	goto	SAT1		
	goto 	SAT_2

; code for television (TV1)

TV_1
	movf	REMOTE_M,w	; most significant remote code 
	andlw	B'00110111'	; mask out bit 7 and 6 and toggle bit
	
	xorlw	B'00110000'	; compare with start bits and ms 3-bits of address
	btfss	STATUS,Z	; if zero then matching
	goto	CLR_RMF	; clear remote flag
	

; input
	movf	REMOTE_L,w
	xorlw	B'00000001'	; bits 0-5 keycode (1), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	INPUT_CHNG
	movf	REMOTE_L,w
	xorlw	B'00000010'	; bits 0-5 keycode (2), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	INPUT_CHNG
	movf	REMOTE_L,w
	xorlw	B'00000011'	; bits 0-5 keycode (3), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	INPUT_CHNG
	movf	REMOTE_L,w
	xorlw	B'00000100'	; bits 0-5 keycode (4), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	INPUT_CHNG
	movf	REMOTE_L,w
	xorlw	B'00000101'	; bits 0-5 keycode (5), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	INPUT_CHNG
	movf	REMOTE_L,w
	xorlw	B'00000110'	; bits 0-5 keycode (6), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	INPUT_CHNG
	goto	CLR_RMF


; satellite
	
SAT1
	movf	REMOTE_M,w	; most significant remote code 
	andlw	B'00110111'	; mask out bit 7 and 6 and toggle bit
	
	xorlw	B'00110010'	; compare with start bits and ms 3-bits of address
	btfss	STATUS,Z	; if zero then matching
	goto	CLR_RMF	; clear remote flag

	
; input
	movf	REMOTE_L,w
	xorlw	B'00000001'	; bits 0-5 keycode (1), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	INPUT_CHNG
	movf	REMOTE_L,w
	xorlw	B'00000010'	; bits 0-5 keycode (2), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	INPUT_CHNG
	movf	REMOTE_L,w
	xorlw	B'00000011'	; bits 0-5 keycode (3), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	INPUT_CHNG
	movf	REMOTE_L,w
	xorlw	B'00000100'	; bits 0-5 keycode (4), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	INPUT_CHNG
	movf	REMOTE_L,w
	xorlw	B'00000101'	; bits 0-5 keycode (5), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	INPUT_CHNG
	movf	REMOTE_L,w
	xorlw	B'00000110'	; bits 0-5 keycode (6), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	INPUT_CHNG
	goto	CLR_RMF

; satellite
SAT_2

	movf	REMOTE_M,w	; most significant remote code 
	andlw	B'00110111'	; mask out bit 7 and 6 and toggle bit

	xorlw	B'00110010'	; compare with start bits and ms 3-bits of address
	btfss	STATUS,Z	; if zero then matching
	goto	CLR_RMF	; clear remote flag
	

; input
	movf	REMOTE_L,w
	xorlw	B'10000001'	; bits 0-5 keycode (1), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	INPUT_CHNG
	movf	REMOTE_L,w
	xorlw	B'10000010'	; bits 0-5 keycode (2), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	INPUT_CHNG
	movf	REMOTE_L,w
	xorlw	B'10000011'	; bits 0-5 keycode (3), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	INPUT_CHNG
	movf	REMOTE_L,w
	xorlw	B'10000100'	; bits 0-5 keycode (4), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	INPUT_CHNG
	movf	REMOTE_L,w
	xorlw	B'10000101'	; bits 0-5 keycode (5), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	INPUT_CHNG
	movf	REMOTE_L,w
	xorlw	B'10000110'	; bits 0-5 keycode (6), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	INPUT_CHNG
;	goto	CLR_RMF

CLR_RMF	
	movlw	D'6'			; set delay period of about 1.5ms 
	call		DELAYT		; delay
	clrf		REM_FLG	; remote flag cleared
	goto	CK_AGN

INPUT_CHNG
; change input selection
	movf	REMOTE_L,w	; key code 1 to 6
	andlw	B'00000111'		; remove the higher bits
	movwf	INPUT

; store value
	bcf		INTCON,GIE		; disable interrupt
	movlw	EEPROM1
	call		EEREAD		; sets EEADR
	movf	INPUT,w
	call		EEWRITE

 ; read input selection (input1, input2 or input3)
	movlw	EEPROM1
	call		EEREAD
	movwf	INPUT

; set outputs for  selected input
	movlw	B'01000000'		; keep RA6 high if it is an output (IR receiver input)
	movwf	PORTA
	clrf		PORTB
	movf	INPUT,w
	xorlw	D'1'
	btfsc	STATUS,Z
	bsf		PORTA,2		; input 1
	movf	INPUT,w
	xorlw	D'2'
	btfsc	STATUS,Z
	bsf		PORTA,3		; input 2
	movf	INPUT,w
	xorlw	D'3'
	btfsc	STATUS,Z
	bsf		PORTA,4		; input 3
	movf	INPUT,w
	xorlw	D'4'
	btfsc	STATUS,Z
	bsf		PORTB,0		; input 4
	movf	INPUT,w
	xorlw	D'5'
	btfsc	STATUS,Z
	bsf		PORTB,1		; input 5
	movf	INPUT,w
	xorlw	D'6'
	btfsc	STATUS,Z
	bsf		PORTB,2		; input 6

	goto	CLR_RMF

; **********************************************************

; subroutines

; delay subroutine
DELAY	
	movlw	D'255'		; about 1s
DELAYT
	movwf	VALUE_1		; VALUE_1 = w
LP_X
	movlw	D'255'		; set delay period value 2 
	movwf	VALUE_2		; VALUE_2 = w
LP_Y
	decfsz	VALUE_2,f	; decrease VALUE_2, skip if zero
	goto 	LP_Y
	decfsz	VALUE_1,f	; decrease VALUE_1, skip if zero
	goto	LP_X
	return
	
; subroutine to read EEPROM memory 

EEREAD
	bsf 		STATUS,RP1	; select memory bank 2
	movwf 	EEADR		; indirect special function register
	bsf 		STATUS,RP0	; select memory bank 3
	bcf		EECON1,EEPGD; data memory
	bsf		EECON1,RD	; read EEPROM
	bcf 		STATUS,RP0	; select memory bank 2
	movf	EEDATA,w	; EEPROM value in w
	bcf		STATUS,RP1	; select bank 0
	return

; subroutine to write to EEPROM

; EEPROM write 

EEWRITE
	bsf		STATUS,RP1	; select bank 2
	movwf	EEDATA		; data register
	bsf		STATUS,RP0	; bank 3
	bcf		EECON1,EEPGD; data memory
	bsf		EECON1,WREN	; enable write
	movlw	H'55'			; place 55H in w for write sequence
	movwf 	EECON2 		; write 55H to EECON2
	movlw 	H'AA'			; AAH to w
	movwf	EECON2		; write AA to EECON2
	bsf		EECON1,WR	; set WR bit and begin write sequence
	bcf		EECON1,WREN	; clear WREN bit
WRITE1	

	btfsc	EECON1,WR	; skip if write complete WR=0 when write complete
	goto 	WRITE1			; not written yet
	bcf		EECON1,EEIF	; clear write interrupt flag
	bcf		STATUS,RP0
	bcf		STATUS,RP1	; bank 0 
	bsf		INTCON,GIE		; enable interrupt
	return					; value written
	
	end


	
